/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryObject<T>
implements Supplier<T> {
    private Supplier<? extends T> getter;
    private final class_2960 id;
    private T value;
    @Nullable
    private final class_5321<T> key;
    @Nullable
    private class_6880<T> holder;
    private static final RegistryObject<?> EMPTY = new RegistryObject();

    private static <T> RegistryObject<T> empty() {
        RegistryObject<?> t = EMPTY;
        return t;
    }

    private RegistryObject() {
        this.id = null;
        this.key = null;
    }

    public RegistryObject(class_2960 id, class_5321<?> key) {
        this.id = id;
        this.key = key;
    }

    void setValue(T value) {
        this.value = value;
    }

    void setGetter(Supplier<? extends T> getter) {
        this.getter = getter;
    }

    public class_2960 getId() {
        return this.id;
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = this.getter.get();
        }
        return this.value;
    }

    @Nullable
    public class_5321<T> getKey() {
        return this.key;
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.get()) ? this : RegistryObject.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.get()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isPresent() ? mapper.apply((T)this.get()) : null;
    }

    public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isPresent() ? this.get() : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @NotNull
    public Optional<class_6880<T>> getHolder() {
        class_2960 registryName;
        class_2378 registry;
        if (this.holder == null && this.key != null && RegistryObject.registryExists(this.key.method_41185()) && (registry = (class_2378)class_7923.field_41167.method_10223(registryName = this.key.method_41185())) != null) {
            this.holder = registry.method_40264(this.key).orElse(null);
        }
        return Optional.ofNullable(this.holder);
    }

    private static boolean registryExists(class_2960 registryName) {
        return class_7923.field_41167.method_10250(registryName);
    }
}

